
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Evans Fisher Gourio Krane %
% BPEA Spring 2015          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% this file calculates optimal policy (under discretion)
% in a backward-looking model, with predictable variation + persistent shock to natural rate,
% and persistent cost push shock. also calculates equilibrium under
% different rules for policy and compares the outcomes

% assume that x(t) = delta*x(t-1) - 1/sigma*(i(t) - rho_n(t) - pi(t-1))
% and pi(t) = pi(t-1) + kappa*x(t)
% these equations hold in deviation from a steady-state
% objective is pi^2 + lambda*x^2, discounted at rate beta

clear all ; close all ; clc ;

%%%%%%%%%%%%%%%%%%
% set parameters %
%%%%%%%%%%%%%%%%%%


basicparam ; % parameters for both models

basicparamBL ; % parameters that exist only in the BL model


%%%%%%%%%%%%%%%%%%%%%%%%%
% real code starts here %
%%%%%%%%%%%%%%%%%%%%%%%%%

input_shocks ;

% design grids for x and pi and i - put more points in the middle
grid_x = [lx,-.25,-.2,-.15,-.1,-0.08,-0.06,-0.045,-0.03,linspace(-0.025,0.025,n_x-18),.03,0.045,0.06,0.08,.1,.15,.2,.25,ux] ; % linspace(-lx,ux,n_x) ;
%             grid_x = linspace(lx,ux,n_x) ;
grid_pi = [lpi,-0.035,linspace(-0.02,0.02,n_pi-4),.035,upi] ; % linspace(-lx,ux,n_x) ;
%             grid_pi =  linspace(lpi,upi,n_pi) ;
grid_i = [linspace(ZLBI,.04,n_i-80),linspace(.041,maxi,80)] ;
% grid_i = [linspace(ZLBI,.02,n_i-30),linspace(.021,maxi,30)] ;

% define median values:
fx   = round(median((1:n_x))) ;
fpi  = round(median((1:n_pi))) ;


% preliminaries for computation - create grids
grid_xS = repmat(grid_x',[1 n_pi]) ;
grid_piS = repmat(grid_pi,[n_x 1]) ;
grid_x_large = repmat(grid_x,[n_i 1 n_pi]) ;
grid_i_large = repmat(grid_i',[1 n_x n_pi]) ;
grid_pi_large = permute(repmat(grid_pi',[1 n_i n_x]),[2 3 1] ) ;
potential_x_todayK = delta*grid_x_large - 1/sigma*(grid_i_large-grid_pi_large) ;

% define arrays to store results:
VK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
int_polK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
x_polK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
pi_polK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;

VdumbK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
int_poldumbK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
x_poldumbK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
pi_poldumbK = zeros(n_x,n_pi,T,n_eps,n_u,3) ;

int_polKA = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
x_polKA = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
pi_polKA = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
lossKA = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
checkKA = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
x_pathKA = zeros(T,3) ;
pi_pathKA = zeros(T,3) ;

int_polKB = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
x_polKB = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
pi_polKB = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
lossKB = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
checkKB = zeros(n_x,n_pi,T,n_eps,n_u,3) ;

int_polKC = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
x_polKC = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
pi_polKC = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
lossKC = zeros(n_x,n_pi,T,n_eps,n_u,3) ;
checkKC = zeros(n_x,n_pi,T,n_eps,n_u,3) ;

x_pathK = zeros(T,3) ;
x_pathKB = zeros(T,3) ;
x_pathKC = zeros(T,3) ;
pi_pathK = zeros(T,3) ;
pi_pathKB = zeros(T,3) ;
pi_pathKC = zeros(T,3) ;
int_pathK = zeros(T,3) ;
int_pathKA = zeros(T,3) ;
int_pathKB = zeros(T,3) ;
int_pathKC = zeros(T,3) ;
x_pathdumbK = zeros(T,3) ;
pi_pathdumbK = zeros(T,3) ;
int_pathdumbK = zeros(T,3) ;

% check that it is possible to escape the deflation trap given the initial
% condition -- (this program simply checks that some simple policies can avoid deflation)
check_deftrap_backward2 ;
if defltrapindicator==1
    break ;
end

% calculate the steady-state value with VFI
calculate_ss_backward_wzlb ;
Vg = V ;

for is=3 ; % loop over parameters (typically uncertainty) -- to make things go faster, i pick only high uncertainty
    
    % pick parameters to vary
    if is==1
        scaling = 1e-7 ;
    end
    if is==2
        scaling = 0.5 ;
    end
    if is==3
        scaling = 1 ;
    end
    
    sigma_eps = scaling*std_epsX ;
    sigma_u = scaling*std_uX ;
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % define the alternative policy rules (rules A,B,C) %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % taylor rule intercepts
    ggA = zeros(T,n_eps,n_u) ;
    ggB = zeros(T,n_eps,n_u) ;
    ggC = zeros(T,n_eps,n_u) ;
    for t=1:T
        for k=1:n_eps
            for u=1:n_u
                ggA(t,k,u) = rhomean(t) + scalefactor(t)*sigma_eps*grid_eps(k) ;
                ggB(t,k,u) = rhomean(t) + scalefactor(t)*sigma_eps*grid_eps(k) ;
                ggC(t,k,u) = rho_hat ;
            end
        end
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % calculation of optimal policy under discretion %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % predefine arrays to store results:
    V = zeros(n_x,n_pi,T,n_eps,n_u) ;
    optpol = zeros(n_x,n_pi,T,n_eps,n_u) ;
    int_pol = zeros(n_x,n_pi,T,n_eps,n_u) ;
    x_pol = zeros(n_x,n_pi,T,n_eps,n_u) ;
    pi_pol = zeros(n_x,n_pi,T,n_eps,n_u) ;
    
    % set starting values for VFI
    for k=1:n_eps;
        for u=1:n_u;
            V(:,:,T,k,u)  = Vg ;
        end
    end
    
    % VFI loop
    t = T ;
    while t>=2
        
        t = t - 1 ;
        
        for k=1:n_eps
            for u=1:n_u
                
                potential_x_today = potential_x_todayK + (rhomean(t)+scalefactor(t)*sigma_eps*grid_eps(k))/sigma ;
                potential_pi_today = ksi*grid_pi_large + kappa*potential_x_today + scalefactor(t)*sigma_u*grid_u(u)  ;
                
                % here is the cap (from policy - see deflationary trap
                % discussion)
                potential_x_today = max(potential_x_today,lx) ;
                potential_pi_today = max(potential_pi_today,lpi) ;
                
                % The following is not necessary - optimal policy can
                % prevent inflationary traps for reasonable calibrations:
                %  potential_x_today = min(potential_x_today,ux) ;
                %  potential_pi_today = min(potential_pi_today,upi) ;
                %
                
                
                % current payoff for given choice of i, and given
                % x(-1),pi(-1), and eps,u today:
                currentobj = .5*(potential_pi_today.^2 + lambda*potential_x_today.^2) ;
                
                % Expected future value given choice of i, and given x(-1),
                % pi(-1)
                VV = zeros(n_x,n_pi) ;
                for k2=1:n_eps
                    for u2=1:n_u
                        VV = VV + P_eps(k,k2)*P_u(u,u2)*squeeze(V(:,:,t+1,k2,u2)) ;
                    end
                end
                futureval = interp2(grid_pi,grid_x,VV,potential_pi_today,potential_x_today,'linear') ;
                
                % this has some NaNs, corresponding to values outside the
                % grid (on the upper side, since down side is capped and hence inside the grid).
                % optimal policy can, and will, avoid these paths. (not
                % always possible with negative shocks)
                
                % optimization --
                [V(:,:,t,k,u),opt] = min( currentobj + beta*futureval,[],1 );
                optpol(:,:,t,k,u) = opt ;
                int_pol(:,:,t,k,u) = grid_i(opt) ;
                x_pol(:,:,t,k,u) = delta*grid_xS - 1/sigma*(squeeze(grid_i(opt))-grid_piS) + (rhomean(t)+scalefactor(t)*sigma_eps*grid_eps(k))/sigma ;
                pi_pol(:,:,t,k,u) = kappa*x_pol(:,:,t,k,u) + ksi*grid_piS + scalefactor(t)*sigma_u*grid_u(u) ;
                
            end
        end
    end
    
    clear futureval currentobj
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % calculation of policy if the CB does not believe there is uncertainty %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % first step: what is the optimal policy at each t,x,pi,e,u, if you
    % think there will not be future shocks --
    
    % predefine arrays to store results:
    optpoldumb = zeros(n_x,n_pi,T,n_eps,n_u) ;
    int_poldumb = zeros(n_x,n_pi,T,n_eps,n_u) ;
    x_poldumb = zeros(n_x,n_pi,T,n_eps,n_u) ;
    pi_poldumb = zeros(n_x,n_pi,T,n_eps,n_u) ;
    
    if calcdumbpolicy==1;
        
        for tt=1:T-1
            for k=1:n_eps
                for u=1:n_u
                    
                    % assumed path for natural rate and for the cost
                    % push shock
                    assumedpathrho = zeros(T,1) ;
                    assumedpathrho(tt:T) = rhomean(tt:T) + scalefactor(tt:T).*ac_eps.^((0:1:T-tt)')*sigma_eps*grid_eps(k) ;
                    assumedpathu = zeros(T,1) ;
                    assumedpathu(tt:T) = scalefactor(tt:T).*ac_u.^((0:1:T-tt)')*sigma_u*grid_u(u) ;
                    
                    % the fed solves in state (tt,k,u) the problem wo
                    % uncertainty: backwards:
                    t = T ;
                    VSSS = zeros(n_x,n_pi,T) ;
                    VSSS(:,:,T) = Vg ;
                    
                    %                         optpolSSS = zeros(n_x,n_pi,T) ;
                    %                         int_polSSS = zeros(n_x,n_pi,T) ;
                    %                         x_polSSS = zeros(n_x,n_pi,T) ;
                    %                         pi_polSSS = zeros(n_x,n_pi,T) ;
                    
                    while t>=tt+1
                        
                        t = t - 1 ;
                        potential_x_today = potential_x_todayK + assumedpathrho(t)/sigma ;
                        potential_pi_today = ksi*grid_pi_large + kappa*potential_x_today + assumedpathu(t)  ;
                        
                        % here is the cap from policy
                        potential_x_today = max(potential_x_today,lx) ;
                        potential_pi_today = max(potential_pi_today,lpi) ;
                        
                        currentobj = .5*(potential_pi_today.^2 + lambda*potential_x_today.^2) ;
                        
                        % note: no uncertainty here!
                        VV = squeeze(VSSS(:,:,t+1)) ;
                        futureval = interp2(grid_pi,grid_x,VV,potential_pi_today,potential_x_today,'linear') ;
                        
                        % optimization --
                        [VSSS(:,:,t),opt] = min( currentobj + beta*futureval,[],1 );
                    end
                    
                    optpoldumb(:,:,tt,k,u ) = opt ;
                    int_poldumb(:,:,tt,k,u ) = grid_i(opt) ;
                    x_poldumb(:,:,tt,k,u ) = delta*grid_xS - 1/sigma*(squeeze(grid_i(opt))-grid_piS) + assumedpathrho(tt)/sigma   ;
                    pi_poldumb(:,:,tt,k,u ) = kappa* x_poldumb(:,:,tt,k,u ) + ksi*grid_piS + assumedpathu(tt)  ;
                    %                         Vdumb(:,:,tt,k,u) = VSSS(:,:,tt) ;
                end
            end
        end
        clear futureval currentobj
    end
    
    
    % add calc of Vdumb = Actual value of following the dumb policy
    % rule ---
    Mpi_polSSA = max(pi_poldumb,lpi) ;
    Mx_polSSA = max(x_poldumb,lx) ;
    Mpi_polSSA = min(Mpi_polSSA,upi) ;
    Mx_polSSA = min(Mx_polSSA,ux) ;
    
    Vdumb = zeros(n_x,n_pi,T,n_eps,n_u) ;
    % note: for t>=T, so the dumb policy is smart and yields the
    % same value.
    for k=1:n_eps;
        for u=1:n_u;
            Vdumb(:,:,T,k,u) = Vg ;
        end
    end
    
    for t=T-1:-1:1;
        for k=1:n_eps
            for u=1:n_u
                VV = zeros(n_x,n_pi) ;
                for k2=1:n_eps
                    for u2=1:n_u
                        VV = VV + P_eps(k,k2)*P_u(u,u2)*squeeze(Vdumb(:,:,t+1,k2,u2)) ;
                    end
                end
                Vdumb(:,:,t,k,u) = .5*(x_poldumb(:,:,t,k,u).^2*lambda + pi_poldumb(:,:,t,k,u).^2) + beta*interp2(grid_pi,grid_x,VV,Mpi_polSSA(:,:,t,k,u),Mx_polSSA(:,:,t,k,u),'linear') ; ;
            end
        end
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % calculate equilibrium if fed follows taylor rules %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % calculate steady-state (for t>=T, i.e. no uncertainty)
    
    calcvaluetaylorss ;
    
    for vvv=1:3
        
        % load taylor rule parameters:
        if vvv==1; gamma=gammaA ; phi = phiA ; gg = ggA ; end
        if vvv==2; gamma=gammaB ; phi = phiB ; gg = ggB ; end
        if vvv==3; gamma=gammaC ; phi = phiC ; gg = ggC ; end
        
        
        % predefine
        int_polS = zeros(n_x,n_pi,T,n_eps,n_u) ;
        x_polS   = zeros(n_x,n_pi,T,n_eps,n_u) ;
        pi_polS  = zeros(n_x,n_pi,T,n_eps,n_u) ;
        lossS    = zeros(n_x,n_pi,T,n_eps,n_u) ;
        checkS   = zeros(n_x,n_pi,T,n_eps,n_u) ;
        
        for t=T:-1:1
            for k=1:n_eps
                for u=1:n_u
                    
                    try_x = 1/(1+gamma/sigma+kappa*phi/sigma)*(delta*grid_xS - 1/sigma*( gg(t,k,u) - (rhomean(t)+sigma_eps*scalefactor(t)*grid_eps(k)) - grid_piS) -phi/sigma*sigma_u*scalefactor(t)*grid_u(u)-phi/sigma*ksi*grid_piS ) ;
                    try_pi = ksi*grid_piS + kappa*try_x + scalefactor(t)*sigma_u*grid_u(u) ;
                    try_x2 = delta*grid_xS - 1/sigma*( ZLBI - (rhomean(t)+sigma_eps*scalefactor(t)*grid_eps(k)) - grid_piS ) ;
                    try_pi2 = ksi*grid_piS + kappa*try_x2 + scalefactor(t)*sigma_u*grid_u(u) ;
                    
                    I1  = (try_x*gamma+try_pi*phi + gg(t,k,u)>=ZLBI) ;
                    I2 =  (try_x2*gamma+try_pi2*phi+ gg(t,k,u)<ZLBI) ;
                    
                    x_polS(:,:,t,k,u) = try_x.*I1 + I2.*try_x2 ;
                    pi_polS(:,:,t,k,u) = try_pi.*I1 + try_pi2.*I2 ;
                    int_polS(:,:,t,k,u)  = I1.*(try_x*gamma+try_pi*phi+ gg(t,k,u)) ;
                    
                    checkS(:,:,t,k,u) = I1 + I2 ; % if 0, it means no eq, and if 2, it means 2 - this turns out to be always 1 i.e. OK
                end
            end
        end
        
        Mpi_polS = max(pi_polS,lpi) ;
        Mx_polS = max(x_polS,lx) ;
        % problem - under rule A (follow natural rate, not Taylor), there is an inflationary trap too. hence:
        Mpi_polS = min(Mpi_polS,upi) ;
        Mx_polS = min(Mx_polS,ux) ;
        % this implicitely assumes some other policy intervention to prevent inflationary eq
        for k=1:n_eps
            for u=1:n_u;
                lossS(:,:,T,k,u) = keep_loss_taylor(:,:,vvv) ;
            end
        end
        
        % calculate loss function given this rule :
        
        for t=T-1:-1:1
            for k=1:n_eps
                for u=1:n_u
                    VVI = zeros(n_x,n_pi) ;
                    for k2=1:n_eps
                        for u2=1:n_u
                            VVI = VVI + P_eps(k,k2)*P_u(u,u2)*squeeze(lossS(:,:,t+1,k2,u2)) ; % this assumes a loss of 0 for time >=T
                        end
                    end
                    lossS(:,:,t,k,u) = .5*(x_polS(:,:,t,k,u).^2*lambda + pi_polS(:,:,t,k,u).^2) + beta*interp2(grid_pi,grid_x,VVI,Mpi_polS(:,:,t,k,u),Mx_polS(:,:,t,k,u),'linear') ;
                end
            end
        end
        
        
        %  --- save policies corresponding to each rule ---
        if vvv==1; x_polA = x_polS ; pi_polA = pi_polS ; int_polA = int_polS ; checkA = checkS ; lossA = lossS ; end
        if vvv==2; x_polB = x_polS ; pi_polB = pi_polS ; int_polB = int_polS ; checkB = checkS ; lossB = lossS ; end
        if vvv==3; x_polC = x_polS ; pi_polC = pi_polS ; int_polC = int_polS ; checkC = checkS ; lossC = lossS ; end
        clear int_polS x_polS pi_polS lossS checkS Mpi_polS Mx_polS lossS
    end
    
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % simulation of a path, under opt policy and under any rule %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % simulation assumign shocks remain at 0 (but people expect
    % uncertainty)
    
    for vvv2=1:5 ;
        
        if vvv2==1; x_polSS = x_pol  ; pi_polSS = pi_pol ;  int_pol_SS = int_pol ;  end
        if vvv2==2; x_polSS = x_polA ; pi_polSS = pi_polA ; int_pol_SS = int_polA ; end
        if vvv2==3; x_polSS = x_polB ; pi_polSS = pi_polB ; int_pol_SS = int_polB ; end
        if vvv2==4; x_polSS = x_polC ; pi_polSS = pi_polC ; int_pol_SS = int_polC ; end
        if vvv2==5; x_polSS = x_poldumb ; pi_polSS = pi_poldumb ; int_pol_SS = int_poldumb ; end
        
        %%% simulate path starting from x0,pi0, assuming zero shocks %%%
        i_pathSS = zeros(T,1) ;
        x_pathSS = zeros(T,1) ;
        pi_pathSS = zeros(T,1) ;
        
        varm = 'linear' ;
        
        for t=1:T
            if t>1
                i_pathSS(t)  = interp2(grid_pi,grid_x,int_pol_SS(:,:,t,feps,fu),pi_pathSS(t-1),x_pathSS(t-1),varm) ;
                x_pathSS(t)  = interp2(grid_pi,grid_x,x_polSS(:,:,t,feps,fu),pi_pathSS(t-1),x_pathSS(t-1),varm) ;
                pi_pathSS(t) = interp2(grid_pi,grid_x,pi_polSS(:,:,t,feps,fu),pi_pathSS(t-1),x_pathSS(t-1),varm) ;
            else
                i_pathSS(t)  = interp2(grid_pi,grid_x,int_pol_SS(:,:,t,feps,fu),pi0,x0,varm) ;
                x_pathSS(t)  = interp2(grid_pi,grid_x,x_polSS(:,:,t,feps,fu),pi0,x0,varm) ;
                pi_pathSS(t) = interp2(grid_pi,grid_x,pi_polSS(:,:,t,feps,fu),pi0,x0,varm) ;
            end
            x_pathSS(t) = max(lx,x_pathSS(t)) ;
            pi_pathSS(t) = max(lpi,pi_pathSS(t)) ;
        end
        
        if vvv2==1; x_path  = x_pathSS  ; pi_path  = pi_pathSS ; i_path  = i_pathSS ; end
        if vvv2==2; x_pathA = x_pathSS  ; pi_pathA = pi_pathSS ; i_pathA = i_pathSS ; end
        if vvv2==3; x_pathB = x_pathSS  ; pi_pathB = pi_pathSS ; i_pathB = i_pathSS ; end
        if vvv2==4; x_pathC = x_pathSS  ; pi_pathC = pi_pathSS ; i_pathC = i_pathSS ; end
        if vvv2==5; x_pathdumb = x_pathSS ; pi_pathdumb = pi_pathSS ; int_pathdumb = i_pathSS ; end
        
        clear x_polSS pi_polSS int_pol_SS
    end
    
    
    % store all the results
    VK(:,:,:,:,:,is) = V ;
    %         optpolK(:,:,:,:,:,is) = optpol ;
    int_polK(:,:,:,:,:,is) = int_pol ;
    x_polK(:,:,:,:,:,is) = x_pol ;
    pi_polK(:,:,:,:,:,is) = pi_pol ;
    
    
    x_poldumbK(:,:,:,:,:,is) = x_poldumb ;
    %         optpoldumbK(:,:,:,:,:,is) = optpoldumb ;
    pi_poldumbK(:,:,:,:,:,is) = pi_poldumb ;
    int_poldumbK(:,:,:,:,:,is) = int_poldumb ;
    VdumbK(:,:,:,:,:,is) = Vdumb ;
    
    int_polKA(:,:,:,:,:,is) = int_polA ;
    x_polKA(:,:,:,:,:,is) = x_polA ;
    pi_polKA(:,:,:,:,:,is) = pi_polA ;
    checkKA(:,:,:,:,:,is) = checkA ;
    lossKA(:,:,:,:,:,is) = lossA ;
    
    int_polKB(:,:,:,:,:,is) = int_polB ;
    x_polKB(:,:,:,:,:,is) = x_polB ;
    pi_polKB(:,:,:,:,:,is) = pi_polB ;
    checkKB(:,:,:,:,:,is) = checkB ;
    lossKB(:,:,:,:,:,is) = lossB ;
    
    int_polKC(:,:,:,:,:,is) = int_polC ;
    x_polKC(:,:,:,:,:,is) = x_polC ;
    pi_polKC(:,:,:,:,:,is) = pi_polC ;
    checkKC(:,:,:,:,:,is) = checkC ;
    lossKC(:,:,:,:,:,is) = lossC ;
    
    x_pathK(:,is) = x_path ;
    pi_pathK(:,is) = pi_path ;
    int_pathK(:,is) = i_path ;
    
    x_pathKA(:,is) = x_pathA ;
    pi_pathKA(:,is) = pi_pathA ;
    int_pathKA(:,is) = i_pathA ;
    
    x_pathKB(:,is) = x_pathB ;
    pi_pathKB(:,is) = pi_pathB ;
    int_pathKB(:,is) = i_pathB ;
    
    x_pathKC(:,is) = x_pathC ;
    pi_pathKC(:,is) = pi_pathC ;
    int_pathKC(:,is) = i_pathC ;
    
    
    x_pathdumbK(:,is) = x_pathdumb ;
    pi_pathdumbK(:,is) = pi_pathdumb ;
    int_pathdumbK(:,is) = int_pathdumb ;    
    
    clear optpol x_poldumb pi_poldumb int_poldumb Vdumb optpoldumb int_pol x_pol pi_pol int_polA x_polA pi_polA lossA checkA int_polB x_polB pi_polB lossB checkB int_polC x_polC pi_polC lossC checkC
    
    
end

%%%%%%%%%%%%%%%%
% Basic figure %
%%%%%%%%%%%%%%%%

figure_BL ;

%%%%%%%%%%%%%%%%%%%
% Cost-push shock %
%%%%%%%%%%%%%%%%%%%

illustrate_shocksBL ;


%%%%%%%%%%%%%%%
% Simulations %
%%%%%%%%%%%%%%%

simuls_BL ;

%%%%%%%%%%%%%%%%%
% Second figure %
%%%%%%%%%%%%%%%%%

% figure_BLmeanmedian ;
